/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.player.videolan;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.watermedia.api.player.videolan.NeoBasePlayer;
import org.watermedia.videolan4j.BufferFormat;
import org.watermedia.videolan4j.ByteBufferFactory;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_display_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_lock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_unlock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_video_cleanup_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_video_format_cb;
import org.watermedia.videolan4j.binding.lib.Kernel32;
import org.watermedia.videolan4j.binding.lib.LibC;
import org.watermedia.videolan4j.binding.lib.size_t;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;

class NeoVideoPlayer
extends NeoBasePlayer
implements libvlc_video_format_cb,
libvlc_video_cleanup_cb,
libvlc_lock_callback_t,
libvlc_unlock_callback_t,
libvlc_display_callback_t {
    private final BufferFormat bufferFormat = BufferFormat.RGBA;
    private final Semaphore semaphore = new Semaphore(1);
    private ByteBuffer[] nativeBuffers;
    private Pointer[] pointers;
    private boolean update;

    public NeoVideoPlayer(MediaPlayerFactory factory, Executor renderExecutor) {
        super(factory);
    }

    public void preRender() {
    }

    @Override
    public void display(Pointer pointer, Pointer pointer1) {
        this.semaphore.release();
        this.update = true;
    }

    @Override
    public Pointer lock(Pointer opaque, PointerByReference planes) {
        planes.getPointer().write(0L, this.pointers, 0, this.pointers.length);
        this.semaphore.acquireUninterruptibly();
        return null;
    }

    @Override
    public void unlock(Pointer pointer, Pointer pointer1, Pointer pointer2) {
    }

    @Override
    public int format(PointerByReference opaque, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
        int w = width.getValue();
        int h = height.getValue();
        byte[] chromaBytes = this.bufferFormat.getChroma().getBytes();
        int[] pitchValues = this.bufferFormat.getPitches(w, h);
        int[] lineValues = this.bufferFormat.getLines(w, h);
        chroma.getPointer().write(0L, chromaBytes, 0, Math.min(chromaBytes.length, 4));
        pitches.getPointer().write(0L, pitchValues, 0, pitchValues.length);
        lines.getPointer().write(0L, lineValues, 0, lineValues.length);
        this.nativeBuffers = new ByteBuffer[pitchValues.length];
        this.pointers = new Pointer[pitchValues.length];
        for (int i = 0; i < pitchValues.length; ++i) {
            ByteBuffer buffer = ByteBufferFactory.alloc(pitchValues[i] * lineValues[i]);
            if (!ByteBufferFactory.isAligned(ByteBufferFactory.address(buffer))) {
                VideoLan4J.LOGGER.warn("Detected an unaligned buffer. this might lead in I/O issues");
            }
            this.nativeBuffers[i] = buffer;
            this.pointers[i] = Pointer.createConstant((long)ByteBufferFactory.address(buffer));
            if (!Platform.isWindows()) {
                LibC.INSTANCE.mlock(this.pointers[i], new NativeLong((long)buffer.capacity()));
                continue;
            }
            Kernel32.INSTANCE.VirtualLock(this.pointers[i], new size_t(buffer.capacity()));
        }
        return this.nativeBuffers.length;
    }

    @Override
    public void cleanup(Pointer pointer) {
        if (this.nativeBuffers != null) {
            for (int i = 0; i < this.nativeBuffers.length; ++i) {
                if (!Platform.isWindows()) {
                    LibC.INSTANCE.munlock(this.pointers[i], new NativeLong((long)this.nativeBuffers[i].capacity()));
                    continue;
                }
                Kernel32.INSTANCE.VirtualUnlock(this.pointers[i], new size_t(this.nativeBuffers[i].capacity()));
            }
            for (ByteBuffer buffer : this.nativeBuffers) {
                ByteBufferFactory.dealloc(buffer);
            }
            this.nativeBuffers = null;
            this.pointers = null;
        }
    }
}

